#include <windows.h>

LRESULT CALLBACK WndProc(HWND,UINT,WPARAM,LPARAM);
HINSTANCE g_hInst;
HWND hWndMain;
LPCTSTR lpszClass=TEXT("WM_CTLCOLORBTN");

int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance
	  ,LPSTR lpszCmdParam,int nCmdShow)
{
	HWND hWnd;
	MSG Message;
	WNDCLASS WndClass;
	g_hInst=hInstance;
	
	WndClass.cbClsExtra=0;
	WndClass.cbWndExtra=0;
	WndClass.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);
	WndClass.hCursor=LoadCursor(NULL,IDC_ARROW);
	WndClass.hIcon=LoadIcon(NULL,IDI_APPLICATION);
	WndClass.hInstance=hInstance;
	WndClass.lpfnWndProc=(WNDPROC)WndProc;
	WndClass.lpszClassName=lpszClass;
	WndClass.lpszMenuName=NULL;
	WndClass.style=CS_HREDRAW | CS_VREDRAW;
	RegisterClass(&WndClass);

	hWnd=CreateWindow(lpszClass,lpszClass,WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
		NULL,(HMENU)NULL,hInstance,NULL);
	ShowWindow(hWnd,nCmdShow);
	hWndMain=hWnd;
	
	while(GetMessage(&Message,0,0,0)) {
		TranslateMessage(&Message);
		DispatchMessage(&Message);
	}
	return (int)Message.wParam;
}

HWND hBtn1,hBtn2;
LRESULT CALLBACK WndProc(HWND hWnd,UINT iMessage,WPARAM wParam,LPARAM lParam)
{
	HDC hdc;
	PAINTSTRUCT ps;
	static HBRUSH hBrush;
    LPDRAWITEMSTRUCT lpdis; 

	switch(iMessage) {
	case WM_CREATE:
		hBtn1=CreateWindow("button"," ư",WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			20,20,100,25,hWnd,(HMENU)0,g_hInst,NULL);
		hBtn2=CreateWindow("button","",WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
			20,120,100,25,hWnd,(HMENU)1,g_hInst,NULL);
		hBrush=CreateSolidBrush(RGB(0,0,255));
		return 0;
	case WM_CTLCOLORBTN:
		SetTextColor((HDC)wParam,RGB(0,255,0));
		SetBkColor((HDC)wParam,RGB(0,0,255));
		return (LRESULT)hBrush;
    case WM_DRAWITEM: 
        lpdis = (LPDRAWITEMSTRUCT)lParam;
        if (lpdis->itemState & ODS_SELECTED) {
			TextOut(lpdis->hDC,2,2,"õ",6);
		} else {
			TextOut(lpdis->hDC,2,2,"ȼ",6);
		}
        return 0; 
	case WM_COMMAND:
		switch(LOWORD(wParam)) {
		case 0:
			MessageBox(hWnd," ư ϴ.","˸",MB_OK);
			break;
		case 1:
			MessageBox(hWnd," ο ư ϴ.","˸",MB_OK);
			break;
		}
		return 0;
	case WM_PAINT:
		hdc=BeginPaint(hWnd, &ps);
		EndPaint(hWnd, &ps);
		return 0;
	case WM_DESTROY:
		DeleteObject(hBrush);
		PostQuitMessage(0);
		return 0;
	}
	return(DefWindowProc(hWnd,iMessage,wParam,lParam));
}
