#include <windows.h>

LRESULT CALLBACK WndProc(HWND,UINT,WPARAM,LPARAM);
HINSTANCE g_hInst;
HWND hWndMain;
LPCTSTR lpszClass=TEXT("WM_DRAWITEM");

int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance
	  ,LPSTR lpszCmdParam,int nCmdShow)
{
	HWND hWnd;
	MSG Message;
	WNDCLASS WndClass;
	g_hInst=hInstance;
	
	WndClass.cbClsExtra=0;
	WndClass.cbWndExtra=0;
	WndClass.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);
	WndClass.hCursor=LoadCursor(NULL,IDC_ARROW);
	WndClass.hIcon=LoadIcon(NULL,IDI_APPLICATION);
	WndClass.hInstance=hInstance;
	WndClass.lpfnWndProc=(WNDPROC)WndProc;
	WndClass.lpszClassName=lpszClass;
	WndClass.lpszMenuName=NULL;
	WndClass.style=CS_HREDRAW | CS_VREDRAW;
	RegisterClass(&WndClass);

	hWnd=CreateWindow(lpszClass,lpszClass,WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
		NULL,(HMENU)NULL,hInstance,NULL);
	ShowWindow(hWnd,nCmdShow);
	hWndMain=hWnd;
	
	while(GetMessage(&Message,0,0,0)) {
		TranslateMessage(&Message);
		DispatchMessage(&Message);
	}
	return (int)Message.wParam;
}

HWND hList;
LRESULT CALLBACK WndProc(HWND hWnd,UINT iMessage,WPARAM wParam,LPARAM lParam)
{
	HDC hdc;
	PAINTSTRUCT ps;
	LPMEASUREITEMSTRUCT lpmis;
	LPDRAWITEMSTRUCT lpdis;
	HBRUSH bkBrush, hBrush, OldBrush;

	switch(iMessage) {
	case WM_CREATE:
		hList=CreateWindow("listbox",NULL,WS_CHILD | WS_VISIBLE | WS_BORDER |
			WS_VSCROLL | LBS_NOTIFY | LBS_OWNERDRAWFIXED,
			10,10,110,200,hWnd,(HMENU)0,g_hInst,NULL);
		SendMessage(hList,LB_ADDSTRING,0,(LPARAM)RGB(255,0,0));
		SendMessage(hList,LB_ADDSTRING,0,(LPARAM)RGB(0,255,0));
		SendMessage(hList,LB_ADDSTRING,0,(LPARAM)RGB(0,0,255));
		return 0;
	case WM_MEASUREITEM:
		lpmis=(LPMEASUREITEMSTRUCT)lParam;
		lpmis->itemHeight=30;
		return TRUE;
	case WM_DRAWITEM:
		lpdis=(LPDRAWITEMSTRUCT)lParam;

		if (lpdis->itemState & ODS_SELECTED) {
			bkBrush=CreateSolidBrush(RGB(255,255,0));
		}
		else {
			bkBrush=CreateSolidBrush(RGB(255,255,255));
		}
		FillRect(lpdis->hDC, &lpdis->rcItem, bkBrush);

		if (lpdis->itemState & ODS_FOCUS) {
			DrawFocusRect(lpdis->hDC,&lpdis->rcItem);
		}

		hBrush=CreateSolidBrush(lpdis->itemData);
		OldBrush=(HBRUSH)SelectObject(lpdis->hDC,hBrush);
		Rectangle(lpdis->hDC,lpdis->rcItem.left+5,lpdis->rcItem.top+5,
			lpdis->rcItem.right-5,lpdis->rcItem.bottom-5);
		SelectObject(lpdis->hDC,OldBrush);
		DeleteObject(hBrush);
		DeleteObject(bkBrush);
		return TRUE;
	case WM_PAINT:
		hdc=BeginPaint(hWnd, &ps);
		EndPaint(hWnd, &ps);
		return 0;
	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
	}
	return(DefWindowProc(hWnd,iMessage,wParam,lParam));
}
